/* ============ */
/* runmnsd.c	*/
/* ============ */
#include <assert.h>
#include <stdio.h>
#include <miscdefs.h>
#include <math.h>

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	double	CalcHarm F((int, UINT));

# undef F
/* INDENT ON */

/* ==================================================================== */
/* RunMeanStdDev - Calculates Mean No. Variates & Std Dev. for Run Test	*/
/* ==================================================================== */
void
RunMeanStdDev(UINT SetSize, UINT Width, double *Mean, double *StdDev)
{
    /* --------------------------------------------------------- */
    /* Width is maximum number of unique integers in a data set. */
    /* These equations were taken from D. E. Knuth, "The Art of  */
    /* Computer Programming," Volume 2, Seminumerical Algorithms */
    /* (1981), page 536 (top).					 */
    /* --------------------------------------------------------- */
    assert(SetSize >= Width);
    *Mean   = SetSize *
		(CalcHarm(1, SetSize) - CalcHarm(1, SetSize - Width));
    *StdDev = sqrt(SQR((double)SetSize)*
		(CalcHarm(2, SetSize) - CalcHarm(2, SetSize - Width))
		- *Mean);
}
